package org.semanticweb.ruqar.examples;

import java.util.List;

import org.semanticweb.ruqar.owl.OWLReasoning;
import org.semanticweb.ruqar.rules.Rule;
import org.semanticweb.ruqar.transformations.OWLIntoRules;
import org.semanticweb.ruqar.transformations.RulesIntoJessRules;
import org.semanticweb.ruqar.transformations.RulesIntoGoalDrivenRules;
import org.semanticweb.owlapi.model.OWLOntology;

/**
 * Example class how to transform OWL 2 ontology into Drools rules.
 * @author Jaroslaw Bak
 *
 */
public class OntologyToGoalDrivenRulesInJessExample {

	public static void main(String[] args) {
		
		//set input files
		String path = "./ontologies/";
		String fileName = "vicodi_0/vicodi_0.owl";
		
		//load an ontology
		OWLReasoning reasoning = new OWLReasoning(path+fileName, null);
				
		//check if an ontology is withing the OWL 2 Profile
		System.out.println(reasoning.getOWL2ProfileInformation());
		
		//you need to remove SWRL rules since HermiT does not handle them
		//reasoning.removeSWRLRulesFromOntology();
		OWLOntology newOnto = reasoning.doReasoning(true, false);
		//reasoning.restoreSWRLRulesInOntology(); //you can restore rules here
		
		//OWL 2 ontology into rules
		OWLIntoRules trans = new OWLIntoRules(newOnto);
				
		//Transform OWL 2 ontology into ASRF rules
		List<Rule> allRules = trans.getAllOntologyAndSWRLAsRules();
		
		//Print transformed ASRF rules
		System.out.println("Number of generated rules: " + allRules.size());
		for(Rule r : allRules)
		{
			System.out.println("OWLAxiom: " + r.getOWLAxiom() + "\n" + r.prettyPrint() +"Rule is safe? " + r.isSafe() + "\n");
		}
		
		//Transform ASRF rules into Goal Driven Rules
		RulesIntoGoalDrivenRules gdr = new RulesIntoGoalDrivenRules(allRules);
		List<Rule> gdrRules = gdr.getGoalDrivenRules();

		//Transform GDR rules into Jess rules
		RulesIntoJessRules jessRules = new RulesIntoJessRules();
		List<String> jess = jessRules.getTransformatedRules(gdrRules);
		for(String s : jess)
		{
			System.out.println(s);
		}
		
		//save GDR Jess rules
		jessRules.saveRulesToFile(path+fileName+"_GDR.clp", jess);
	}
}
