package org.semanticweb.ruqar.examples;

import java.util.List;

import org.semanticweb.ruqar.owl.OWLReasoning;
import org.semanticweb.ruqar.rules.Rule;
import org.semanticweb.ruqar.transformations.OWLIntoRules;
import org.semanticweb.ruqar.transformations.RulesIntoDroolsRules;
import org.semanticweb.ruqar.transformations.RulesIntoGoalDrivenRules;
import org.semanticweb.owlapi.model.OWLOntology;

/**
 * Example class how to transform OWL 2 ontology into Drools rules.
 * @author Jaroslaw Bak
 *
 */
public class OntologyToGoalDrivenRulesInDroolsExample {

	
	public static void main(String[] args) {
		
		//set input files
		String path = "./ontologies/";
		String fileName = "vicodi_0/vicodi_0.owl";
		
		//load an ontology
		OWLReasoning reasoning = new OWLReasoning(path+fileName, null);
				
		//check if an ontology is withing the OWL 2 Profile
		System.out.println(reasoning.getOWL2ProfileInformation());
		
		//you need to remove SWRL rules since HermiT does not handle them
		//reasoning.removeSWRLRulesFromOntology();
		OWLOntology newOnto = reasoning.doReasoning(true, false);
		//reasoning.restoreSWRLRulesInOntology(); //you can restore rules here
		
		//OWL 2 ontology into rules
		OWLIntoRules trans = new OWLIntoRules(newOnto);
				
		//Transform OWL 2 ontology into ASRF rules
		List<Rule> allRules = trans.getAllOntologyAndSWRLAsRules();
		
		//Print transformed ASRF rules
		System.out.println("Number of generated rules: " + allRules.size());
		for(Rule r : allRules)
		{
			System.out.println("OWLAxiom: " + r.getOWLAxiom() + "\n" + r.prettyPrint() +"Rule is safe? " + r.isSafe() + "\n");
		}
		
		//Transform ASRF rules into Goal Driven Rules
		RulesIntoGoalDrivenRules gdr = new RulesIntoGoalDrivenRules(allRules);
		List<Rule> gdrRules = gdr.getGoalDrivenRules();
		
		//Transform GDR rules into Drools rules
		RulesIntoDroolsRules droolsRules = new RulesIntoDroolsRules();
		List<String> drools = droolsRules.getTransformatedRules(gdrRules);
		for(String s : drools)
		{
			System.out.println(s);
		}
		
		//save GDR Drools rules
		droolsRules.saveRulesToFile(path+fileName+"_GDR.drl", drools);
	}
}
